
CREATE INDEX idx_aanduidingid
  ON bouwplan
  USING btree
  (aanduidingid);

-- Index: idx_bouwplan_gist

-- DROP INDEX idx_bouwplan_gist;

CREATE INDEX idx_bouwplan_gist
  ON bouwplan
  USING gist
  (the_geom);

-- Index: idx_gemeenteid

-- DROP INDEX idx_gemeenteid;

CREATE INDEX idx_gemeenteid
  ON bouwplan
  USING btree
  (gemeenteid);

-- Index: idx_statusplanologischid

-- DROP INDEX idx_statusplanologischid;

CREATE INDEX idx_statusplanologischid
  ON bouwplan
  USING btree
  (statusplanologischid);

-- Index: idx_statusprojectid

-- DROP INDEX idx_statusprojectid;

CREATE INDEX idx_statusprojectid
  ON bouwplan
  USING btree
  (statusprojectid);

CREATE INDEX idx_bouwplanopmerking_bouwplanid
  ON bouwplanopmerking
  USING btree
  (bouwplanid);

CREATE INDEX idx_bouwplanvoortgang_bouwplanid
  ON bouwplanvoortgang
  USING btree
  (bouwplanid);

CREATE INDEX idx_bouwplanid
  ON factmetperiode
  USING btree
  (bouwplanid);

-- Index: idx_factsoortid

-- DROP INDEX idx_factsoortid;

CREATE INDEX idx_factsoortid
  ON factmetperiode
  USING btree
  (factsoortid);

-- Index: idx_periodeid

-- DROP INDEX idx_periodeid;

CREATE INDEX idx_periodeid
  ON factmetperiode
  USING btree
  (periodeid);
  
  
CREATE UNIQUE INDEX gebruiker_lower_username_idx
  ON gebruiker
  USING btree
  (lower(btrim(username::text)));

CREATE INDEX gemeente_geom_gist
  ON gemeente_geom
  USING gist
  (the_geom);

CREATE INDEX idx_periode_omschrijving
  ON periode
  USING btree
  (omschrijving);

  
CREATE INDEX provincie_geom_idx
  ON provincie
  USING gist
  (the_geom);

CREATE INDEX idx_gebruikgegevensid
   ON bouwplan USING btree (gebruikgegevensid ASC NULLS LAST);
   
   
CREATE INDEX idx_provincie_regio
   ON regio_provincie USING btree (provincie ASC NULLS LAST);
   CREATE INDEX idx_regio
   ON regio_provincie USING btree (regio ASC NULLS LAST);